const express = require("express");
const sqlite3 = require("sqlite3").verbose();
const path = require("path");
const app = express();
const db = new sqlite3.Database("data.db");

const ADMIN_PASSWORD = process.env.ADMIN_PASSWORD || "honshu2026";

app.use(express.json());
app.use(express.static(path.join(__dirname, "public"))); // your honshu-jog-local.html here

// Init tables
db.serialize(() => {
  db.run("CREATE TABLE IF NOT EXISTS progress (id INTEGER PRIMARY KEY, total REAL)");
  db.run("CREATE TABLE IF NOT EXISTS messages (id INTEGER PRIMARY KEY, name TEXT, msg TEXT, created TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
  db.get("SELECT * FROM progress WHERE id=1", (err, row) => {
    if (!row) db.run("INSERT INTO progress (id, total) VALUES (1, 0)");
  });
});

// Progress
app.get("/api/progress", (req, res) => {
  db.get("SELECT total FROM progress WHERE id=1", (err, row) => res.json(row));
});

app.post("/api/progress", (req, res) => {
  if (req.body.password !== ADMIN_PASSWORD) return res.status(403).json({error:"forbidden"});
  const distance = parseFloat(req.body.distance);
  if (!distance || distance <= 0) return res.status(400).json({error:"invalid"});
  db.run("UPDATE progress SET total = total + ?", [distance], () => {
    db.get("SELECT total FROM progress WHERE id=1", (err, row) => res.json(row));
  });
});

// Messages
app.get("/api/messages", (req, res) => {
  db.all("SELECT * FROM messages ORDER BY created DESC", (err, rows) => res.json(rows));
});

app.post("/api/messages", (req, res) => {
  const {name, msg} = req.body;
  if (!msg) return res.status(400).json({error:"empty"});
  db.run("INSERT INTO messages (name,msg) VALUES (?,?)", [name||"Anonymous", msg], function() {
    res.json({id:this.lastID, name:name||"Anonymous", msg});
  });
});

app.delete("/api/messages/:id", (req, res) => {
  if (req.body.password !== ADMIN_PASSWORD) return res.status(403).json({error:"forbidden"});
  db.run("DELETE FROM messages WHERE id=?", [req.params.id], function() {
    res.json({deleted:this.changes});
  });
});

app.listen(3000, () => console.log("Server on http://0.0.0.0:3000"));
